#ifndef __ECAT_ERROR_H
#define __ECAT_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT Base stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_BASE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_ECAT_BASE_COMMAND_INVALID  ((TLR_RESULT)0xC0200001L)

//
// MessageId: TLR_W_ECAT_BASE_MAILBOX_NOT_ACTIVE
//
// MessageText:
//
//  Mailbox communication is not active.
//
#define TLR_W_ECAT_BASE_MAILBOX_NOT_ACTIVE ((TLR_RESULT)0x80200002L)

//
// MessageId: TLR_W_ECAT_BASE_NO_MAILBOX_TYPE_RECEIVER_CONNECTED
//
// MessageText:
//
//  No receiver for mailbox type connected.
//
#define TLR_W_ECAT_BASE_NO_MAILBOX_TYPE_RECEIVER_CONNECTED ((TLR_RESULT)0x80200003L)

//
// MessageId: TLR_E_ECAT_BASE_MBX_INVALID_TYPE
//
// MessageText:
//
//  Invalid Mailbox type id.
//
#define TLR_E_ECAT_BASE_MBX_INVALID_TYPE ((TLR_RESULT)0xC0200004L)

//
// MessageId: TLR_E_ECAT_BASE_MBX_ALREADY_CONNECTED
//
// MessageText:
//
//  Mailbox type is already connected to listener.
//
#define TLR_E_ECAT_BASE_MBX_ALREADY_CONNECTED ((TLR_RESULT)0xC0200005L)

//
// MessageId: TLR_E_ECAT_BASE_TOO_MANY_ALCONTROL_RECEIVERS
//
// MessageText:
//
//  Too many ALcontrol receivers registered.
//
#define TLR_E_ECAT_BASE_TOO_MANY_ALCONTROL_RECEIVERS ((TLR_RESULT)0xC0200006L)

//
// MessageId: TLR_E_ECAT_BASE_QUEUE_DOES_NOT_EXIST
//
// MessageText:
//
//  Queue does not exist.
//
#define TLR_E_ECAT_BASE_QUEUE_DOES_NOT_EXIST ((TLR_RESULT)0xC0200007L)

//
// MessageId: TLR_E_ECAT_BASE_MBX_PACKET_TOO_LONG
//
// MessageText:
//
//  Queue does not exist.
//
#define TLR_E_ECAT_BASE_MBX_PACKET_TOO_LONG ((TLR_RESULT)0xC0200008L)

//
// MessageId: TLR_E_ECAT_BASE_NO_QUEUE_REGISTERED_FOR_MBX_TYPE
//
// MessageText:
//
//  No queue registered for mailbox type.
//
#define TLR_E_ECAT_BASE_NO_QUEUE_REGISTERED_FOR_MBX_TYPE ((TLR_RESULT)0xC0200009L)

//
// MessageId: TLR_E_ECAT_BASE_DEADSLAVE_CALLBACK_TABLE_FULL
//
// MessageText:
//
//  Dead slave callback table full.
//
#define TLR_E_ECAT_BASE_DEADSLAVE_CALLBACK_TABLE_FULL ((TLR_RESULT)0xC020000AL)

//
// MessageId: TLR_E_ECAT_BASE_NO_SUCH_ETHERCAT_STACK_NAME
//
// MessageText:
//
//  No EtherCAT stack with that name.
//
#define TLR_E_ECAT_BASE_NO_SUCH_ETHERCAT_STACK_NAME ((TLR_RESULT)0xC020000BL)

//
// MessageId: TLR_E_ECAT_BASE_DUPLICATE_ETHERCAT_STACK_NAME
//
// MessageText:
//
//  Duplicate EtherCAT stack name.
//
#define TLR_E_ECAT_BASE_DUPLICATE_ETHERCAT_STACK_NAME ((TLR_RESULT)0xC020000CL)

//
// MessageId: TLR_E_ECAT_BASE_DYNAMICDATA_INVALID
//
// MessageText:
//
//  EtherCAT stack dynamic data invalid.
//
#define TLR_E_ECAT_BASE_DYNAMICDATA_INVALID ((TLR_RESULT)0xC020000DL)

//
// MessageId: TLR_E_ECAT_BASE_INVALID_TIMEOUT_PARAMS
//
// MessageText:
//
//  Invalid timeout parameters.
//
#define TLR_E_ECAT_BASE_INVALID_TIMEOUT_PARAMS ((TLR_RESULT)0xC020000EL)

//
// MessageId: TLR_E_ECAT_BASE_NOT_ENOUGH_MEMORY
//
// MessageText:
//
//  Not enough memory.
//
#define TLR_E_ECAT_BASE_NOT_ENOUGH_MEMORY ((TLR_RESULT)0xC020000FL)

//
// MessageId: TLR_E_ECAT_BASE_INVALID_ALSTATUS_STATE_CHANGE
//
// MessageText:
//
//  Not enough memory.
//
#define TLR_E_ECAT_BASE_INVALID_ALSTATUS_STATE_CHANGE ((TLR_RESULT)0xC0200010L)

//
// MessageId: TLR_E_ECAT_BASE_NO_DATA_AVAILABLE
//
// MessageText:
//
//  Not enough memory.
//
#define TLR_E_ECAT_BASE_NO_DATA_AVAILABLE ((TLR_RESULT)0xC0200011L)

//
// MessageId: TLR_E_ECAT_BASE_ALREADY_CONNECTED
//
// MessageText:
//
//  Not enough memory.
//
#define TLR_E_ECAT_BASE_ALREADY_CONNECTED ((TLR_RESULT)0xC0200012L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT CoE stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_COE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_ECAT_COE_COMMAND_INVALID   ((TLR_RESULT)0xC0210001L)

//
// MessageId: TLR_W_ECAT_COE_NO_SERVICE_RECEIVER_CONNECTED
//
// MessageText:
//
//  No CoE Service receiver connected.
//
#define TLR_W_ECAT_COE_NO_SERVICE_RECEIVER_CONNECTED ((TLR_RESULT)0x80210002L)

//
// MessageId: TLR_E_ECAT_COE_INVALID_SERVICE_TYPE
//
// MessageText:
//
//  Invalid CoE service type id.
//
#define TLR_E_ECAT_COE_INVALID_SERVICE_TYPE ((TLR_RESULT)0xC0210003L)

//
// MessageId: TLR_E_ECAT_COE_ALREADY_CONNECTED
//
// MessageText:
//
//  CoE service already connected.
//
#define TLR_E_ECAT_COE_ALREADY_CONNECTED ((TLR_RESULT)0xC0210004L)

//
// MessageId: TLR_E_ECAT_COE_QUEUE_DOES_NOT_EXIST
//
// MessageText:
//
//  Queue does not exist.
//
#define TLR_E_ECAT_COE_QUEUE_DOES_NOT_EXIST ((TLR_RESULT)0xC0210005L)

//
// MessageId: TLR_E_ECAT_COE_PDO_INVALID_ID
//
// MessageText:
//
//  Invalid PDO Id.
//
#define TLR_E_ECAT_COE_PDO_INVALID_ID    ((TLR_RESULT)0xC0210006L)

//
// MessageId: TLR_E_ECAT_COE_PDO_UNDEFINED_ID
//
// MessageText:
//
//  Undefined PDO Id.
//
#define TLR_E_ECAT_COE_PDO_UNDEFINED_ID  ((TLR_RESULT)0xC0210007L)

//
// MessageId: TLR_E_ECAT_COE_PDO_MAPPING_FAILED_DUE_TO_MISSING_OBJECT
//
// MessageText:
//
//  PDO Mapping failed due to missing object.
//
#define TLR_E_ECAT_COE_PDO_MAPPING_FAILED_DUE_TO_MISSING_OBJECT ((TLR_RESULT)0xC0210008L)

//
// MessageId: TLR_E_ECAT_COE_SDO_PROTOCOL_TIMEOUT
//
// MessageText:
//
//  SDO Protocol timeout.
//
#define TLR_E_ECAT_COE_SDO_PROTOCOL_TIMEOUT ((TLR_RESULT)0xC0210009L)

//
// MessageId: TLR_E_ECAT_COE_SDO_SCS_SPECIFIER_INVALID
//
// MessageText:
//
//  Client/Server command specifier not valid or unknown.
//
#define TLR_E_ECAT_COE_SDO_SCS_SPECIFIER_INVALID ((TLR_RESULT)0xC021000AL)

//
// MessageId: TLR_E_ECAT_COE_SDO_OUT_OF_MEMORY
//
// MessageText:
//
//  Out of Memory.
//
#define TLR_E_ECAT_COE_SDO_OUT_OF_MEMORY ((TLR_RESULT)0xC021000BL)

//
// MessageId: TLR_E_ECAT_COE_SDO_UNSUPPORTED_ACCESS_TO_OBJECT
//
// MessageText:
//
//  Unsupported access to an object.
//
#define TLR_E_ECAT_COE_SDO_UNSUPPORTED_ACCESS_TO_OBJECT ((TLR_RESULT)0xC021000CL)

//
// MessageId: TLR_E_ECAT_COE_SDO_ATTEMPT_TO_READ_A_WRITE_ONLY_OBJECT
//
// MessageText:
//
//  Attempt to read a write only object.
//
#define TLR_E_ECAT_COE_SDO_ATTEMPT_TO_READ_A_WRITE_ONLY_OBJECT ((TLR_RESULT)0xC021000DL)

//
// MessageId: TLR_E_ECAT_COE_SDO_ATTEMPT_TO_WRITE_A_READ_ONLY_OBJECT
//
// MessageText:
//
//  Attempt to write a read only object.
//
#define TLR_E_ECAT_COE_SDO_ATTEMPT_TO_WRITE_A_READ_ONLY_OBJECT ((TLR_RESULT)0xC021000EL)

//
// MessageId: TLR_E_ECAT_COE_SDO_OBJECT_DOES_NOT_EXIST
//
// MessageText:
//
//  The object does not exist in the object dictionary.
//
#define TLR_E_ECAT_COE_SDO_OBJECT_DOES_NOT_EXIST ((TLR_RESULT)0xC021000FL)

//
// MessageId: TLR_E_ECAT_COE_SDO_OBJECT_CAN_NOT_BE_MAPPED_INTO_THE_PDO
//
// MessageText:
//
//  The object can not be mapped into the PDO.
//
#define TLR_E_ECAT_COE_SDO_OBJECT_CAN_NOT_BE_MAPPED_INTO_THE_PDO ((TLR_RESULT)0xC0210010L)

//
// MessageId: TLR_E_ECAT_COE_SDO_OBJECTS_WOULD_EXCEED_PDO_LENGTH
//
// MessageText:
//
//  The number and length of the objects to be mapped would exceed the PDO length.
//
#define TLR_E_ECAT_COE_SDO_OBJECTS_WOULD_EXCEED_PDO_LENGTH ((TLR_RESULT)0xC0210011L)

//
// MessageId: TLR_E_ECAT_COE_SDO_GENERAL_PARAMETER_INCOMPATIBILITY_REASON
//
// MessageText:
//
//  General parameter incompatibility reason.
//
#define TLR_E_ECAT_COE_SDO_GENERAL_PARAMETER_INCOMPATIBILITY_REASON ((TLR_RESULT)0xC0210012L)

//
// MessageId: TLR_E_ECAT_COE_SDO_GENERAL_INTERNAL_INCOMPATIBILITY_IN_DEVICE
//
// MessageText:
//
//  General internal incompatibility in the device.
//
#define TLR_E_ECAT_COE_SDO_GENERAL_INTERNAL_INCOMPATIBILITY_IN_DEVICE ((TLR_RESULT)0xC0210013L)

//
// MessageId: TLR_E_ECAT_COE_SDO_ACCESS_FAILED_DUE_TO_A_HARDWARE_ERROR
//
// MessageText:
//
//  Access failed due to a hardware error.
//
#define TLR_E_ECAT_COE_SDO_ACCESS_FAILED_DUE_TO_A_HARDWARE_ERROR ((TLR_RESULT)0xC0210014L)

//
// MessageId: TLR_E_ECAT_COE_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_DOES_NOT_MATCH
//
// MessageText:
//
//  Data type does not match, length of service parameter does not match.
//
#define TLR_E_ECAT_COE_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_DOES_NOT_MATCH ((TLR_RESULT)0xC0210015L)

//
// MessageId: TLR_E_ECAT_COE_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_HIGH
//
// MessageText:
//
//  Data type does not match, length of service parameter too high.
//
#define TLR_E_ECAT_COE_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_HIGH ((TLR_RESULT)0xC0210016L)

//
// MessageId: TLR_E_ECAT_COE_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_LOW
//
// MessageText:
//
//  Data type does not match, length of service parameter too low.
//
#define TLR_E_ECAT_COE_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_LOW ((TLR_RESULT)0xC0210017L)

//
// MessageId: TLR_E_ECAT_COE_SDO_SUBINDEX_DOES_NOT_EXIST
//
// MessageText:
//
//  Subindex does not exist.
//
#define TLR_E_ECAT_COE_SDO_SUBINDEX_DOES_NOT_EXIST ((TLR_RESULT)0xC0210018L)

//
// MessageId: TLR_E_ECAT_COE_SDO_VALUE_RANGE_OF_PARAMETER_EXCEEDED
//
// MessageText:
//
//  Value range of parameter exceeded.
//
#define TLR_E_ECAT_COE_SDO_VALUE_RANGE_OF_PARAMETER_EXCEEDED ((TLR_RESULT)0xC0210019L)

//
// MessageId: TLR_E_ECAT_COE_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_HIGH
//
// MessageText:
//
//  Value of parameter written too high.
//
#define TLR_E_ECAT_COE_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_HIGH ((TLR_RESULT)0xC021001AL)

//
// MessageId: TLR_E_ECAT_COE_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_LOW
//
// MessageText:
//
//  Value of parameter written too low.
//
#define TLR_E_ECAT_COE_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_LOW ((TLR_RESULT)0xC021001BL)

//
// MessageId: TLR_E_ECAT_COE_SDO_MAXIMUM_VALUE_IS_LESS_THAN_MINIMUM_VALUE
//
// MessageText:
//
//  Maximum value is less than minimum value.
//
#define TLR_E_ECAT_COE_SDO_MAXIMUM_VALUE_IS_LESS_THAN_MINIMUM_VALUE ((TLR_RESULT)0xC021001CL)

//
// MessageId: TLR_E_ECAT_COE_SDO_GENERAL_ERROR
//
// MessageText:
//
//  General error.
//
#define TLR_E_ECAT_COE_SDO_GENERAL_ERROR ((TLR_RESULT)0xC021001DL)

//
// MessageId: TLR_E_ECAT_COE_SDO_DATA_CANNOT_BE_TRANSFERRED_OR_STORED_TO_THE_APP
//
// MessageText:
//
//  Data cannot be transferred or stored to the application.
//
#define TLR_E_ECAT_COE_SDO_DATA_CANNOT_BE_TRANSFERRED_OR_STORED_TO_THE_APP ((TLR_RESULT)0xC021001EL)

//
// MessageId: TLR_E_ECAT_COE_SDO_DATA_NO_TRANSFER_DUE_TO_LOCAL_CONTROL
//
// MessageText:
//
//  Data cannot be transferred or stored to the application because of local control.
//
#define TLR_E_ECAT_COE_SDO_DATA_NO_TRANSFER_DUE_TO_LOCAL_CONTROL ((TLR_RESULT)0xC021001FL)

//
// MessageId: TLR_E_ECAT_COE_SDO_DATA_NO_TRANSFER_DUE_TO_PRESENT_DEVICE_STATE
//
// MessageText:
//
//  Data cannot be transferred or stored to the application because of present device state.
//
#define TLR_E_ECAT_COE_SDO_DATA_NO_TRANSFER_DUE_TO_PRESENT_DEVICE_STATE ((TLR_RESULT)0xC0210020L)

//
// MessageId: TLR_E_ECAT_COE_SDO_NO_OBJECT_DICTIONARY_PRESENT
//
// MessageText:
//
//  Object dictionary dynamic generation fails or no object dictionary present.
//
#define TLR_E_ECAT_COE_SDO_NO_OBJECT_DICTIONARY_PRESENT ((TLR_RESULT)0xC0210021L)

//
// MessageId: TLR_E_ECAT_COE_SDO_UNKNOWN_ABORT_CODE
//
// MessageText:
//
//  Unknown SDO abort code.
//
#define TLR_E_ECAT_COE_SDO_UNKNOWN_ABORT_CODE ((TLR_RESULT)0xC0210022L)

//
// MessageId: TLR_E_ECAT_COE_SDO_TOGGLE_BIT_NOT_TOGGLED
//
// MessageText:
//
//  SDO toggle bit was not toggled.
//
#define TLR_E_ECAT_COE_SDO_TOGGLE_BIT_NOT_TOGGLED ((TLR_RESULT)0xC0210023L)

//
// MessageId: TLR_E_ECAT_COE_SDO_CLIENT_STACK_BUSY
//
// MessageText:
//
//  SDO client stack busy.
//
#define TLR_E_ECAT_COE_SDO_CLIENT_STACK_BUSY ((TLR_RESULT)0xC0210024L)

//
// MessageId: TLR_E_ECAT_COE_SDO_CLIENT_STACK_NO_TRANSFER
//
// MessageText:
//
//  SDO client stack has no active transfer identified by station address.
//
#define TLR_E_ECAT_COE_SDO_CLIENT_STACK_NO_TRANSFER ((TLR_RESULT)0xC0210025L)

//
// MessageId: TLR_E_ECAT_COE_PDO_SUBOBJECT_PTR_UNALIGNED
//
// MessageText:
//
//  Subobject data pointer is unaligned.
//
#define TLR_E_ECAT_COE_PDO_SUBOBJECT_PTR_UNALIGNED ((TLR_RESULT)0xC0210026L)

//
// MessageId: TLR_E_ECAT_COE_COULD_NOT_SEND_MBX_MESSAGE
//
// MessageText:
//
//  Could not send mailbox message.
//
#define TLR_E_ECAT_COE_COULD_NOT_SEND_MBX_MESSAGE ((TLR_RESULT)0xC0210027L)

//
// MessageId: TLR_E_ECAT_COE_INVALID_MBX_MESSAGE
//
// MessageText:
//
//  Could not send mailbox message due to format errors.
//
#define TLR_E_ECAT_COE_INVALID_MBX_MESSAGE ((TLR_RESULT)0xC0210028L)

//
// MessageId: TLR_E_ECAT_COE_NO_OBJECT_DICTIONARY_PRESENT
//
// MessageText:
//
//  No object dictionary present.
//
#define TLR_E_ECAT_COE_NO_OBJECT_DICTIONARY_PRESENT ((TLR_RESULT)0xC0210029L)

//
// MessageId: TLR_E_ECAT_COE_INVALID_PDO_DBM_CONFIGURATION
//
// MessageText:
//
//  Invalid PDO DBM configuration.
//
#define TLR_E_ECAT_COE_INVALID_PDO_DBM_CONFIGURATION ((TLR_RESULT)0xC021002AL)

//
// MessageId: TLR_I_ECAT_COE_CONFIG_INTERFACE_NOT_INITIALIZED
//
// MessageText:
//
//  configuration interface not initialized.
//
#define TLR_I_ECAT_COE_CONFIG_INTERFACE_NOT_INITIALIZED ((TLR_RESULT)0x4021002BL)

//
// MessageId: TLR_W_ECAT_COE_NO_OUTPUT_DATA
//
// MessageText:
//
//  no output data available.
//
#define TLR_W_ECAT_COE_NO_OUTPUT_DATA    ((TLR_RESULT)0x8021002CL)

//
// MessageId: TLR_E_ECAT_COE_INVALID_TIMEOUT_PARAMS
//
// MessageText:
//
//  Invalid timeout parameters.
//
#define TLR_E_ECAT_COE_INVALID_TIMEOUT_PARAMS ((TLR_RESULT)0xC021002DL)

//
// MessageId: TLR_E_ECAT_COE_SHUTDOWN_ACTIVE
//
// MessageText:
//
//  Shutdown on task is active.
//
#define TLR_E_ECAT_COE_SHUTDOWN_ACTIVE   ((TLR_RESULT)0xC021002EL)

//
// MessageId: TLR_E_ECAT_COE_OD_NOTIFY_TABLE_FULL
//
// MessageText:
//
//  Od Notify Table Full.
//
#define TLR_E_ECAT_COE_OD_NOTIFY_TABLE_FULL ((TLR_RESULT)0xC021002FL)

//
// MessageId: TLR_E_ECAT_COE_OD_UNDEFINED_NOTIFY_APPLICATION_ALREADY_REGISTERED
//
// MessageText:
//
//  An application already registered for the Undefined object notify.
//
#define TLR_E_ECAT_COE_OD_UNDEFINED_NOTIFY_APPLICATION_ALREADY_REGISTERED ((TLR_RESULT)0xC0210030L)

//
// MessageId: TLR_E_ECAT_COE_OD_SDOINFO_NOTIFY_APPLICATION_ALREADY_REGISTERED
//
// MessageText:
//
//  An application already registered for the SDOInfo packet hook.
//
#define TLR_E_ECAT_COE_OD_SDOINFO_NOTIFY_APPLICATION_ALREADY_REGISTERED ((TLR_RESULT)0xC0210031L)

//
// MessageId: TLR_E_ECAT_COE_OD_DPM_MODE_OBJECTS_CAN_ONLY_BE_READONLY
//
// MessageText:
//
//  DPM Mode Objects can only be set readonly.
//
#define TLR_E_ECAT_COE_OD_DPM_MODE_OBJECTS_CAN_ONLY_BE_READONLY ((TLR_RESULT)0xC0210032L)

//
// MessageId: TLR_E_ECAT_COE_OD_DPM_MODE_OBJECTS_DIRECTION_PARAMETER_INVALID
//
// MessageText:
//
//  Invalid direction parameter for DPM Mode Objects.
//
#define TLR_E_ECAT_COE_OD_DPM_MODE_OBJECTS_DIRECTION_PARAMETER_INVALID ((TLR_RESULT)0xC0210033L)

//
// MessageId: TLR_E_ECAT_COE_OD_DPM_MODE_SUBOBJECT_OFFSET_OUT_OF_RANGE
//
// MessageText:
//
//  Invalid offset parameter for DPM Mode Objects.
//
#define TLR_E_ECAT_COE_OD_DPM_MODE_SUBOBJECT_OFFSET_OUT_OF_RANGE ((TLR_RESULT)0xC0210034L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT VoE stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_VOE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_ECAT_VOE_COMMAND_INVALID   ((TLR_RESULT)0xC0260001L)

//
// MessageId: TLR_W_ECAT_VOE_NO_RECEIVER_FOR_VENDOR_PROFILE
//
// MessageText:
//
//  No receiver for vendor profile.
//
#define TLR_W_ECAT_VOE_NO_RECEIVER_FOR_VENDOR_PROFILE ((TLR_RESULT)0x80260002L)

//
// MessageId: TLR_E_ECAT_VOE_VENDOR_PROFILE_ALREADY_REGISTERED
//
// MessageText:
//
//  Vendor profile is already registered.
//
#define TLR_E_ECAT_VOE_VENDOR_PROFILE_ALREADY_REGISTERED ((TLR_RESULT)0xC0260003L)

//
// MessageId: TLR_E_ECAT_VOE_VENDOR_PROFILE_NOT_REGISTERED
//
// MessageText:
//
//  Vendor profile is not registered.
//
#define TLR_E_ECAT_VOE_VENDOR_PROFILE_NOT_REGISTERED ((TLR_RESULT)0xC0260004L)

//
// MessageId: TLR_E_ECAT_VOE_OUT_OF_MEMORY
//
// MessageText:
//
//  Out of memory.
//
#define TLR_E_ECAT_VOE_OUT_OF_MEMORY     ((TLR_RESULT)0xC0260005L)

//
// MessageId: TLR_E_ECAT_VOE_COULD_NOT_SEND_MBX_MESSAGE
//
// MessageText:
//
//  Could not send mailbox message.
//
#define TLR_E_ECAT_VOE_COULD_NOT_SEND_MBX_MESSAGE ((TLR_RESULT)0xC0260006L)

//
// MessageId: TLR_E_ECAT_VOE_NOT_ENOUGH_MEMORY
//
// MessageText:
//
//  Not enough memory.
//
#define TLR_E_ECAT_VOE_NOT_ENOUGH_MEMORY ((TLR_RESULT)0xC0260007L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT FoE stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_FOE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_ECAT_FOE_COMMAND_INVALID   ((TLR_RESULT)0xC0240001L)

//
// MessageId: TLR_W_ECAT_FOE_INVALID_OPCODE
//
// MessageText:
//
//  Invalid FoE opcode.
//
#define TLR_W_ECAT_FOE_INVALID_OPCODE    ((TLR_RESULT)0x80240002L)

//
// MessageId: TLR_E_ECAT_FOE_UNKNOWN_FILESYSTEM
//
// MessageText:
//
//  Unknown filesystem.
//
#define TLR_E_ECAT_FOE_UNKNOWN_FILESYSTEM ((TLR_RESULT)0xC0240003L)

//
// MessageId: TLR_I_ECAT_FOE_CONFIG_INTERFACE_NOT_INITIALIZED
//
// MessageText:
//
//  configuration interface not initialized.
//
#define TLR_I_ECAT_FOE_CONFIG_INTERFACE_NOT_INITIALIZED ((TLR_RESULT)0x40240004L)

//
// MessageId: TLR_E_ECAT_FOE_INVALID_TIMEOUT_PARAMS
//
// MessageText:
//
//  Invalid timeout parameters.
//
#define TLR_E_ECAT_FOE_INVALID_TIMEOUT_PARAMS ((TLR_RESULT)0xC0240005L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT SoE stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//Range 0x1000-0x7FFF is reserved for SSC error mapping
//Range 0x8000-0x8FFF is reserved for default value error codes
//
// MessageId: TLR_E_ECAT_SOE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_ECAT_SOE_COMMAND_INVALID   ((TLR_RESULT)0xC0220001L)

//
// MessageId: TLR_I_ECAT_SOE_CONFIG_INTERFACE_NOT_INITIALIZED
//
// MessageText:
//
//  configuration interface not initialized.
//
#define TLR_I_ECAT_SOE_CONFIG_INTERFACE_NOT_INITIALIZED ((TLR_RESULT)0x40220002L)

//
// MessageId: TLR_E_ECAT_SOE_INVALID_TIMEOUT_PARAMS
//
// MessageText:
//
//  Invalid timeout parameters.
//
#define TLR_E_ECAT_SOE_INVALID_TIMEOUT_PARAMS ((TLR_RESULT)0xC0220003L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_ALREADY_EXISTS
//
// MessageText:
//
//  IDN already exists.
//
#define TLR_E_ECAT_SOE_IDN_ALREADY_EXISTS ((TLR_RESULT)0xC0220004L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_ATTRIBUTE_INVALID
//
// MessageText:
//
//  Invalid attribute specified.
//
#define TLR_E_ECAT_SOE_IDN_ATTRIBUTE_INVALID ((TLR_RESULT)0xC0220005L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_INVALID_MAX_DATA_SIZE_SPECIFIED
//
// MessageText:
//
//  Invalid max data size specified.
//
#define TLR_E_ECAT_SOE_IDN_INVALID_MAX_DATA_SIZE_SPECIFIED ((TLR_RESULT)0xC0220006L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_DRIVE_NUMBER_INVALID
//
// MessageText:
//
//  Drive number invalid.
//
#define TLR_E_ECAT_SOE_IDN_DRIVE_NUMBER_INVALID ((TLR_RESULT)0xC0220007L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_UNDEFINED_NOTIFY_ALREADY_IN_USE
//
// MessageText:
//
//  Undefined notify already in use.
//
#define TLR_E_ECAT_SOE_IDN_UNDEFINED_NOTIFY_ALREADY_IN_USE ((TLR_RESULT)0xC0220008L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_INVALID_ELEMENT_ID
//
// MessageText:
//
//  Invlaid element id.
//
#define TLR_E_ECAT_SOE_IDN_INVALID_ELEMENT_ID ((TLR_RESULT)0xC0220009L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_APP_PACKET_RESPONSE_INVALID
//
// MessageText:
//
//  Application's Response Packet invalid.
//
#define TLR_E_ECAT_SOE_IDN_APP_PACKET_RESPONSE_INVALID ((TLR_RESULT)0xC022000AL)

//
// MessageId: TLR_E_ECAT_SOE_IDN_APP_SSC_TRANSFER_TOO_LONG
//
// MessageText:
//
//  Application's Transfer Data too long.
//
#define TLR_E_ECAT_SOE_IDN_APP_SSC_TRANSFER_TOO_LONG ((TLR_RESULT)0xC022000BL)

//
// MessageId: TLR_E_ECAT_SOE_IDN_APP_SSC_TRANSFER_LENGTH_WRONG
//
// MessageText:
//
//  Application's Transfer Data length is invalid.
//
#define TLR_E_ECAT_SOE_IDN_APP_SSC_TRANSFER_LENGTH_WRONG ((TLR_RESULT)0xC022000CL)

//
// MessageId: TLR_E_ECAT_SOE_IDN_APP_MTU_TOO_LOW
//
// MessageText:
//
//  Application's MTU is too low.
//
#define TLR_E_ECAT_SOE_IDN_APP_MTU_TOO_LOW ((TLR_RESULT)0xC022000DL)

//
// MessageId: TLR_E_ECAT_SOE_IDN_INVALID_DEST_ID
//
// MessageText:
//
//  ECAT_SOEIDN: Invalid DestId.
//
#define TLR_E_ECAT_SOE_IDN_INVALID_DEST_ID ((TLR_RESULT)0xC022000EL)

//
// MessageId: TLR_E_ECAT_SOE_IDN_LISTS_CANNOT_HAVE_A_MINIMUM_VALUE
//
// MessageText:
//
//  Lists cannot have a minimum value.
//
#define TLR_E_ECAT_SOE_IDN_LISTS_CANNOT_HAVE_A_MINIMUM_VALUE ((TLR_RESULT)0xC022000FL)

//
// MessageId: TLR_E_ECAT_SOE_IDN_LISTS_CANNOT_HAVE_A_MAXIMUM_VALUE
//
// MessageText:
//
//  Lists cannot have a maximum value.
//
#define TLR_E_ECAT_SOE_IDN_LISTS_CANNOT_HAVE_A_MAXIMUM_VALUE ((TLR_RESULT)0xC0220010L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_NAME_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  Name exceeds allocated length.
//
#define TLR_E_ECAT_SOE_IDN_NAME_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0220011L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_UNIT_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  Unit exceeds allocated length.
//
#define TLR_E_ECAT_SOE_IDN_UNIT_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0220012L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_OPDATA_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  OpData exceeds allocated length.
//
#define TLR_E_ECAT_SOE_IDN_OPDATA_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0220013L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_INVALID_MAX_LIST_LENGTH
//
// MessageText:
//
//  Invalid max list length.
//
#define TLR_E_ECAT_SOE_IDN_INVALID_MAX_LIST_LENGTH ((TLR_RESULT)0xC0220014L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_DEFAULT_VALUE_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  Default value exceeds allocated length.
//
#define TLR_E_ECAT_SOE_IDN_DEFAULT_VALUE_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0220015L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_MINIMUM_AND_MAXIMUM_VALUE_MUST_BE_USED_TOGETHER
//
// MessageText:
//
//  Minimum and maximum value must be used together.
//
#define TLR_E_ECAT_SOE_IDN_MINIMUM_AND_MAXIMUM_VALUE_MUST_BE_USED_TOGETHER ((TLR_RESULT)0xC0220016L)

//
// MessageId: TLR_E_ECAT_SOE_IDN_USER_APPLICATION_TRANSFER_ERROR
//
// MessageText:
//
//  User application transfer error.
//
#define TLR_E_ECAT_SOE_IDN_USER_APPLICATION_TRANSFER_ERROR ((TLR_RESULT)0xC0220017L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NO_IDN
//
// MessageText:
//
//  IDN not available.
//
#define TLR_E_ECAT_SOE_SSC_NO_IDN        ((TLR_RESULT)0xC0221001L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_INVALID_ACCESS_TO_ELEMENT_1
//
// MessageText:
//
//  Invalid access to element 1.
//
#define TLR_E_ECAT_SOE_SSC_INVALID_ACCESS_TO_ELEMENT_1 ((TLR_RESULT)0xC0221009L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NO_NAME
//
// MessageText:
//
//  No Name.
//
#define TLR_E_ECAT_SOE_SSC_NO_NAME       ((TLR_RESULT)0xC0222001L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NAME_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Name transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_NAME_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0222002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NAME_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Name transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_NAME_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0222003L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NAME_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Name cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_NAME_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0222004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NAME_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Name is write protected at this time.
//
#define TLR_E_ECAT_SOE_SSC_NAME_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0222005L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_ATTRIBUTE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Attribute transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_ATTRIBUTE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0223002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_ATTRIBUTE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Attribute transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_ATTRIBUTE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0223003L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_ATTRIBUTE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Attribute cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_ATTRIBUTE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0223004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_ATTRIBUTE_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Attribute is write protected at this time.
//
#define TLR_E_ECAT_SOE_SSC_ATTRIBUTE_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0223005L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NO_UNIT
//
// MessageText:
//
//  No unit.
//
#define TLR_E_ECAT_SOE_SSC_NO_UNIT       ((TLR_RESULT)0xC0224001L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_UNIT_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Unit transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_UNIT_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0224002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_UNIT_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Unit transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_UNIT_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0224003L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_UNIT_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Unit cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_UNIT_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0224004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_UNIT_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Unit is write protected at this time.
//
#define TLR_E_ECAT_SOE_SSC_UNIT_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0224005L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NO_MINIMUM_VALUE
//
// MessageText:
//
//  No minimum value.
//
#define TLR_E_ECAT_SOE_SSC_NO_MINIMUM_VALUE ((TLR_RESULT)0xC0225001L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Minimum value transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0225002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Minimum value transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0225003L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Minimum value cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0225004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Minimum value is write protected at this time.
//
#define TLR_E_ECAT_SOE_SSC_MINIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0225005L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NO_MAXIMUM_VALUE
//
// MessageText:
//
//  No maximum value.
//
#define TLR_E_ECAT_SOE_SSC_NO_MAXIMUM_VALUE ((TLR_RESULT)0xC0226001L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Maximum value transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0226002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Maximum value transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0226003L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Maximum value cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0226004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Maximum value is write protected at this time.
//
#define TLR_E_ECAT_SOE_SSC_MAXIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0226005L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Operation data transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0227002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Operation data transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0227003L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Operation data cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0227004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Operation data is write protected at this time.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0227005L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_LOWER_THAN_MINIMUM_VALUE
//
// MessageText:
//
//  Operation data is lower than Minimum value.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_LOWER_THAN_MINIMUM_VALUE ((TLR_RESULT)0xC0227006L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_HIGHER_THAN_MAXIMUM_VALUE
//
// MessageText:
//
//  Operation data is higher than Maximum value.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_HIGHER_THAN_MAXIMUM_VALUE ((TLR_RESULT)0xC0227007L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_INVALID
//
// MessageText:
//
//  Invalid operation data.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_INVALID ((TLR_RESULT)0xC0227008L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_BY_PASSWORD
//
// MessageText:
//
//  Operation data is write protected by password.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_BY_PASSWORD ((TLR_RESULT)0xC0227009L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_DUE_CYCLICALLY_CONFIGURED
//
// MessageText:
//
//  Operation data is write protected. It is configured cyclically.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_DUE_CYCLICALLY_CONFIGURED ((TLR_RESULT)0xC022700AL)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_INVALID_INDIRECT_ADDRESSING
//
// MessageText:
//
//  Invalid indirect addressing.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_INVALID_INDIRECT_ADDRESSING ((TLR_RESULT)0xC022700BL)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_DUE_OTHER_SETTINGS
//
// MessageText:
//
//  Operation data is write protected due other settings.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_DUE_OTHER_SETTINGS ((TLR_RESULT)0xC022700CL)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_INVALID_FLOATING_POINT_NUMBER
//
// MessageText:
//
//  Invalid floating point number.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_INVALID_FLOATING_POINT_NUMBER ((TLR_RESULT)0xC022700DL)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_PARAMETERIZATION_LEVEL
//
// MessageText:
//
//  Operation data is write protected at parameterization level.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_PARAMETERIZATION_LEVEL ((TLR_RESULT)0xC022700EL)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_OPERATION_LEVEL
//
// MessageText:
//
//  Operation data is write protected at operation level.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_OPERATION_LEVEL ((TLR_RESULT)0xC022700FL)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_ALREADY_ACTIVE
//
// MessageText:
//
//  Procedure command already active.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_ALREADY_ACTIVE ((TLR_RESULT)0xC0227010L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_INTERRUPTIBLE
//
// MessageText:
//
//  Procedure command not interruptible.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_INTERRUPTIBLE ((TLR_RESULT)0xC0227011L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_AT_THIS_TIME
//
// MessageText:
//
//  Procedure Command is not executable at this time (e.g. wrong slave state).
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_AT_THIS_TIME ((TLR_RESULT)0xC0227012L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_INVALID_PARAM
//
// MessageText:
//
//  Procedure Command is not executable due invalid parameters.
//
#define TLR_E_ECAT_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_INVALID_PARAM ((TLR_RESULT)0xC0227013L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_NO_DEFAULT_VALUE
//
// MessageText:
//
//  No default value.
//
#define TLR_E_ECAT_SOE_SSC_NO_DEFAULT_VALUE ((TLR_RESULT)0xC0228001L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_DEFAULT_VALUE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Default value cannot be changed (read only).
//
#define TLR_E_ECAT_SOE_SSC_DEFAULT_VALUE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0228004L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_DEFAULT_VALUE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Default value transmision is too short.
//
#define TLR_E_ECAT_SOE_SSC_DEFAULT_VALUE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0228002L)

//
// MessageId: TLR_E_ECAT_SOE_SSC_DEFAULT_VALUE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Default value transmision is too long.
//
#define TLR_E_ECAT_SOE_SSC_DEFAULT_VALUE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0228003L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT AoE stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_AOE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_ECAT_AOE_COMMAND_INVALID   ((TLR_RESULT)0xC0250001L)

//
// MessageId: TLR_I_ECAT_AOE_CONFIG_INTERFACE_NOT_INITIALIZED
//
// MessageText:
//
//  configuration interface not initialized.
//
#define TLR_I_ECAT_AOE_CONFIG_INTERFACE_NOT_INITIALIZED ((TLR_RESULT)0x40250002L)

//
// MessageId: TLR_E_ECAT_AOE_INVALID_TIMEOUT_PARAMS
//
// MessageText:
//
//  Invalid timeout parameters.
//
#define TLR_E_ECAT_AOE_INVALID_TIMEOUT_PARAMS ((TLR_RESULT)0xC0250003L)

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT EoE stack error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_EOE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_ECAT_EOE_COMMAND_INVALID   ((TLR_RESULT)0xC0230001L)

//
// MessageId: TLR_E_ECAT_EOE_VIRTUAL_SWITCH_NOT_PRESENT
//
// MessageText:
//
//  Virtual Switch not present.
//
#define TLR_E_ECAT_EOE_VIRTUAL_SWITCH_NOT_PRESENT ((TLR_RESULT)0xC0230002L)

//
// MessageId: TLR_I_ECAT_EOE_CONFIG_INTERFACE_NOT_INITIALIZED
//
// MessageText:
//
//  configuration interface not initialized.
//
#define TLR_I_ECAT_EOE_CONFIG_INTERFACE_NOT_INITIALIZED ((TLR_RESULT)0x40230002L)

//
// MessageId: TLR_S_ECAT_EOE_IP_CONFIG_DATA_NOT_VALID
//
// MessageText:
//
//  IP configuration data not valid.
//
#define TLR_S_ECAT_EOE_IP_CONFIG_DATA_NOT_VALID ((TLR_RESULT)0x00230003L)

//
// MessageId: TLR_E_ECAT_EOE_INVALID_TIMEOUT_PARAMS
//
// MessageText:
//
//  Invalid timeout parameters.
//
#define TLR_E_ECAT_EOE_INVALID_TIMEOUT_PARAMS ((TLR_RESULT)0xC0230004L)

//
// MessageId: TLR_E_ECAT_EOE_PARAM_UNSPECIFIED_ERROR
//
// MessageText:
//
//  Unspecified Error.
//
#define TLR_E_ECAT_EOE_PARAM_UNSPECIFIED_ERROR ((TLR_RESULT)0xC0230005L)

//
// MessageId: TLR_E_ECAT_EOE_PARAM_UNSUPPORTED_FRAME_TYPE
//
// MessageText:
//
//  Unsupported Frame Type.
//
#define TLR_E_ECAT_EOE_PARAM_UNSUPPORTED_FRAME_TYPE ((TLR_RESULT)0xC0230006L)

//
// MessageId: TLR_E_ECAT_EOE_PARAM_NO_IP_SUPPORT
//
// MessageText:
//
//  No IP Support.
//
#define TLR_E_ECAT_EOE_PARAM_NO_IP_SUPPORT ((TLR_RESULT)0xC0230007L)

//
// MessageId: TLR_E_ECAT_EOE_PARAM_NO_FILTER_SUPPORT
//
// MessageText:
//
//  No Filter Support.
//
#define TLR_E_ECAT_EOE_PARAM_NO_FILTER_SUPPORT ((TLR_RESULT)0xC0230008L)




#endif  //__ECAT_ERROR_H

